{DelphiSim                                   }
{v.1.05                                     }
{Roeland van der Spek                        }
{spekw@acm.org                               }
{(C) 1997                                    }
{Example: Simple Generator - machine model   }

{
 This simple model contains a generator that generates jobs, and
 a machine that processes these jobs. When the simulation terminates
 it will show the number of jobs processed, the total time the machine
 has been active and the number of pending jobs at the moment the simulation
 ended
}

unit Examp2;

interface

uses
  Windows, Messages,SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,Random, machine,tally,delphisim;

type
  TForm1 = class(TForm)
    Simulation1: TSimulation;
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Label7: TLabel;
    Label14: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Simulation1SimEnd;
    procedure Simulation1SimInit(eventlist: TEventList);
    procedure FormActivate(Sender: TObject);
    procedure Simulation1Replication;
    procedure Button2Click(Sender: TObject);
    procedure Simulation1Suspend;
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

{ Define the type Mymachine, In this example we have overriden the
  methods OnArrival and Continue. Note that this is not always
  necesary; by default Onarrival does nothing and continue destroys
  the parameter Object O }

  TMyMachine = class(TMachine)
    procedure onarrival(O:TObject); override;
    procedure continue(O:TObject); override;
  end;

{ The Generartor is defined here. It produces jobs for the machine}

  TGenerator = class(TSimProcess) {define a new process}
    procedure body; override;     {define its body }
  end;

  TJob = class(TObject)
    timein:double;
    timeOut:Double;
  end;

var
  Form1: TForm1;
  MyStream:TRandomStream;
  MyMachine:TMachine;
  Generator:TGenerator;
  MyTally:TTally;

implementation

{ The Generator process goes into a loop until the simulation terminates
  Each cycle it creates a job and calls the machines process method to
  handle the job. The Process method accepts two parameters; the first
  is the job to be handled and the second specifies the processing time
  this job requires}

Procedure TGenerator.body;    {the description of what the process does}
var job:Tjob;
begin
  while not false do
  begin
    holdfor(drawExpo(2,MyStream)); {hold the process (exponential)}
    job:=Tjob.create;
    MyMachine.process(job,DrawExpo(2,mystream));
  end
end;

{
 The Onarrival method is used to define actions that must be executed
 when a job arrives at a machine. In this case we register the time
 at which a job arrives at the machine
}
Procedure TMyMachine.Onarrival(O:TObject);
begin
  (O as TJob).TimeIn:=SimTime; {register the time of arrival at the machine}
end;

{
 The Continue methode is used to define the actions that must be executed
 when a job is finished processing. In this case we Tally the duration
 that the object spent at the machine = waittime + processing time. after this
 the job object is destroyed.
}
procedure TmyMachine.Continue(O:TObject);
var P:TJob;
begin
  P:=O as TJob;
  MyTally.tally(Simtime-P.timein); {tally the duration at the machine}
  P.free                           {clear the job-object}
end;

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  button4.enabled:=true;
  button2.enabled:=true;
  button1.enabled:=false;      {disable the startbutton}
  MyTally:=TTally.create(Simulation1,0);
  Simulation1.startSimulation; {start the simulation}
end;

{
  When the simulation ends the EndSim event is called. Here it
  displays the number of jobs completed, the total active time
  number of jobs pending at simulation end some job characteristics
  e.g. Avarage time in machine, maximum and minimum time in the
  machine
}

procedure TForm1.Simulation1SimEnd;
begin
  button1.enabled:=true;
  button4.enabled:=false;
  button2.enabled:=false;
  button3.enabled:=false;
  Label1.caption:=format('%d',[mymachine.jobsdone]);
  label2.caption:=format('%f',[mymachine.timeactive]);
  Label3.caption:=Format('%d',[mymachine.JobsPending]);
  Label4.caption:=format('%f',[MyTally.avg]);
  label5.caption:=format('%f',[mytally.min]);
  label6.caption:=format('%f',[mytally.max]);
  label7.caption:=format('%d',[mytally.count]);
end;

{ Here the processes are initialized}

procedure TForm1.Simulation1SimInit(eventlist: TEventList);
begin
  MyTally.reset;  {clear the tally object}
  generator := TGenerator.create(Simulation1,0,'Generator');
  MyMachine := TMymachine.create(Simulation1,'The Machine');
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
 MyStream:=TRandomStream.create(133,245);  {create a randomStream}
end;

{
  At the end of each replication, an OnReplicaton event is triggered,
  the screen is updated with the simulation results
}

procedure TForm1.Simulation1Replication;
begin
  label14.caption:=format('%d',[simulation1.RepsLeft]);
  Label1.caption:=format('%d',[mymachine.jobsdone]);
  label2.caption:=format('%f',[mymachine.timeactive]);
  Label3.caption:=Format('%d',[mymachine.JobsPending]);
  Label4.caption:=format('%f',[MyTally.avg]);
  label5.caption:=format('%f',[mytally.min]);
  label6.caption:=format('%f',[mytally.max]);
  label7.caption:=format('%d',[mytally.count]);
end;

{
  Pushing this button will suspend the simulation. When the simulation
  as in fact suspended, an OnSuspent Event will be triggerd.
}
procedure TForm1.Button2Click(Sender: TObject);
begin
  button2.enabled:=false;
  simulation1.suspendSimulation;   {suspends the simulation}
end;

{
  When the simulation has suspended, the OnSuspend event is triggered.
}
procedure TForm1.Simulation1Suspend;
begin
  button3.enabled:=true;
end;

{
  Touching this button will resume the simulation
}
procedure TForm1.Button3Click(Sender: TObject);
begin
  button3.enabled:=false;
  Simulation1.resumeSimulation; {Restarts the simulation}
  button2.enabled:=true;
end;

{
  Touchting this button will terminate the simulation. This will
  trigger an OnSimEnd event
}
procedure TForm1.Button4Click(Sender: TObject);
begin
  Simulation1.terminateSimulation; {yeah! terminate}
end;

end.
